// // // // // // // // // // // // //
//
//	ConnectionStatus
//
//	erstellt 4.12.97 von Andreas Warnke
//	geändert 7.12.97 von Andreas Warnke
//



// // // // // // // // // // // // //
//
//	include
//

#include <Window.h>
#include <OS.h>
#include "ClientApplication.h"
#include "ConnectionStatus.h"
#include "AsciiKette.h"
#include "Playground.h"
#include "FateMaker.h"



// // // // // // // // // // // // //
//
//	statics:
//

unsigned int ConnectionStatus :: NextPortNumber = 1;



// // // // // // // // // // // // //
//
//	Konstruktor
//

ConnectionStatus :: ConnectionStatus ( BRect inRect )
	: BWindow(
		inRect,
		"Enemy Territory Client",
		B_TITLED_WINDOW,
		B_NOT_RESIZABLE | B_NOT_MINIMIZABLE | B_NOT_ZOOMABLE | B_WILL_DRAW)
{	
	//	Name - TextControl:
	NameView = new BTextControl (
		BRect ( 0, 20, 299, 49 ),
		"NameView",
		"Name:",
		"Nobody",
		NULL );
	if ( NameView != NULL )
	{
		NameView -> SetDivider (100.0);
		NameView -> SetAlignment ( B_ALIGN_RIGHT, B_ALIGN_LEFT );
		AddChild ( NameView );
		NameView -> MakeFocus ( true );
	};
		
	//	Password - TextControl:
	/*char * DefaultCode = IntToString ( Fate . GetLong ( 900000000 ) + 100000000 );*/
	char * DefaultCode = NULL;
	PasswordView = new BTextControl (
		BRect ( 0, 50, 299, 79 ),
		"PasswordView",
		"Password:",
		DefaultCode,
		NULL );
	if ( PasswordView != NULL )
	{
		PasswordView -> SetDivider (100.0);
		PasswordView -> SetAlignment ( B_ALIGN_RIGHT, B_ALIGN_LEFT );
		AddChild ( PasswordView );
	};
	if ( DefaultCode != NULL )
		delete DefaultCode;
	
	//	Connect - Button:
	Connector = new BButton (
		BRect ( 250, 90,349, 109 ),
		"Connector",
		"Login",
		new BMessage ( ConnectionStatus_ConnectButton_ )
	);
	if ( Connector != NULL )
	{
		AddChild ( Connector );
		SetDefaultButton ( Connector );
	};
		
	//	Error - StringView initialisieren:
	ErrorLine = new BStringView (
		BRect( 10, 90, 249, 119),
		"ErrorLine",
		NULL
	);
	if ( ErrorLine != NULL )
		AddChild ( ErrorLine ); 
		
	//	Grund:
	BView * sView = new BView (
		Bounds(),
		"Grund",
		B_FOLLOW_ALL_SIDES,
		B_WILL_DRAW );
	if ( sView != NULL )
	{
		sView -> SetViewColor ( 0xdd, 0xdd, 0xdd );
		AddChild ( sView );
	};

	//	Fertig:
	Show ();
};



// // // // // // // // // // // // //
//
//	Destruktor
//

ConnectionStatus :: ~ConnectionStatus ()
{
	//	Children are deleted automatically
	//	by the automaticcaly called Destructor
	//	of the parent class
	ErrorLine = NULL;
	Connector = NULL;
	NameView = NULL;
	PasswordView = NULL;
	
	//	be_app informieren:
	((ClientApplication*) be_app ) -> Login = NULL;
};



// // // // // // // // // // // // //
//
//	ConnectionStatus -> Quit-Button
//

bool ConnectionStatus :: QuitRequested()
{
	if ( be_app -> CountWindows () == 1 )
		//	dies ist das letzte Fenster.
		be_app -> PostMessage ( B_QUIT_REQUESTED );
		
	return(true);
};



// // // // // // // // // // // // //
//
//	ConnectionStatus -> MessageReceived
//

void ConnectionStatus :: MessageReceived ( BMessage *inMessage )
{
	if ( inMessage -> what == ConnectionStatus_ConnectButton_ )
	{
		//	Der Login-Button wurde gedrückt.
		
		if ( TryToConnect () )
			//	Connection steht.
			//	Schließe das Fenster:
			Quit ();
		
		/*
		//	Name & Passwort zurücksetzen:
		if ( NameView != NULL )
		{
			NameView -> SetText ( "Nobody" );
			NameView -> MakeFocus ( true );
		};
		if ( PasswordView != NULL )
		{
			char * RandomNumber = IntToString ( Fate . GetLong ( 900000000 ) + 100000000 );
			PasswordView -> SetText ( RandomNumber );
			if ( RandomNumber != NULL )
				delete [] RandomNumber;
		};
		*/
	}
	else
		//	Es ist keine Login-Button-Message.
		
		//	Default-Action:
		inherited :: MessageReceived ( inMessage );
};



// // // // // // // // // // // // //
//
//	ConnectionStatus -> TryToConnect
//

bool ConnectionStatus :: TryToConnect()
{
	int found = 0;

	//	Message verschicken:
	status_t error;
	BMessenger * derBote = new BMessenger
		( "application/x-vnd.EnemyTerritory.Server" , -1, &error );
	if ( ( error < B_NO_ERROR ) && ( derBote != NULL ) )
	{
		//	Der Server läuft nicht.
		delete derBote;
		be_roster -> Launch ( "application/x-vnd.EnemyTerritory.Server" );
		snooze ( 100000 );
		Activate ();
		derBote = new BMessenger
			( "application/x-vnd.EnemyTerritory.Server" , -1, &error );
	};
	if ( ( error >= B_NO_ERROR ) && ( derBote != NULL ) )
	{
		//	Server app existiert.
		//	Extrahiere Name und Passwort aus Controls:
		char Default_String = '\0';
		const char * ControlName = & Default_String;
		const char * ControlPassword = & Default_String;
		if ( NameView != NULL )
			ControlName = NameView -> Text ();
		if ( PasswordView != NULL )
			ControlPassword = PasswordView -> Text ();
	
		//	Starte neuen Playground:
		BRect sStartPos = ClientApplication :: GetScreenRect ();
		sStartPos . InsetBy ( 10, 10 );
		sStartPos . top = sStartPos . top + 20;
		char * sUniquePortName = IntToString ( NextPortNumber ++ );
		sUniquePortName = ConcatAndDeleteOdd (
			sUniquePortName,
			": ",
			NULL,
			ControlName );
		Playground * WinDow = new Playground (
			sStartPos,
			ControlName,
			ControlPassword,
			sUniquePortName );
		if ( sUniquePortName != NULL )
			delete [] sUniquePortName;
			
		//	Erstellen der Message:
		BMessage dieNachricht ( InterApplicationMessage );
		dieNachricht . AddString("Type","login");
		dieNachricht . AddString("ClientName",ControlName);
		dieNachricht . AddString("Password",ControlPassword);
		dieNachricht . AddInt32("Version",1);
		
		BHandler * ReplyHandler = NULL;
		if ( WinDow -> GetEbene () != NULL )
			ReplyHandler = WinDow -> GetEbene ();
		if ( derBote -> IsValid() )
		{
		 	derBote -> SendMessage ( & dieNachricht, ReplyHandler );
		 	found = 1;
		};
	};

	//	delete:
	if ( derBote != NULL )
		delete derBote;
					
	//	Bearbeite Views -> folglich Lock!
	Lock();
	
	//	Gefunden? Update der statuszeile!
	if ( ErrorLine != NULL )
	{
		if ( found >= 1 )
			ErrorLine -> SetText ( NULL );
		else
			ErrorLine -> SetText ("Error: No local server found.");
	};
		
	//	Unlock:
	Unlock();
	
	//	fertig:
	return ( found >= 1 );
};



//
//	Ende
//
// // // // // // // // // // // // //